/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedContainerNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FieldNode;
import com.inprise.vbroker.compiler.ast.FixedNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.NodeFactory;
import com.inprise.vbroker.compiler.ast.ObjectKey;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.TypeMapper;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;
import com.inprise.vbroker.compiler.backends.depsolver.DepSolverDefs;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.QName;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RepositoryNode
extends Node
implements ContainerNode,
DepSolverDefs {
    public NodeFactory _factory;
    public CommonOptions _options;
    public ErrorReporter _ER;
    public TypeMapper _mapper;
    public Hashtable _objectTable = new Hashtable();
    public Hashtable _repIdTable = new Hashtable();
    public Vector _contents = new Vector();
    public Vector _arrays = new Vector();
    public Vector _sequences = new Vector();
    public Hashtable _strings = new Hashtable();
    public Hashtable _wstrings = new Hashtable();
    public Hashtable _fixeds = new Hashtable();
    public boolean _assignObjectKeys = false;
    public PrimitiveNode ANY_TYPE;
    public PrimitiveNode BOOL_TYPE;
    public PrimitiveNode CHAR_TYPE;
    public PrimitiveNode DOUBLE_TYPE;
    public PrimitiveNode FLOAT_TYPE;
    public PrimitiveNode LONGDOUBLE_TYPE;
    public PrimitiveNode LONGLONG_TYPE;
    public PrimitiveNode LONG_TYPE;
    public PrimitiveNode OBJREF_TYPE;
    public PrimitiveNode OCTET_TYPE;
    public PrimitiveNode PRINCIPAL_TYPE;
    public PrimitiveNode SHORT_TYPE;
    public PrimitiveNode STRING_TYPE;
    public PrimitiveNode TYPECODE_TYPE;
    public PrimitiveNode ULONGLONG_TYPE;
    public PrimitiveNode ULONG_TYPE;
    public PrimitiveNode USHORT_TYPE;
    public PrimitiveNode VOID_TYPE;
    public PrimitiveNode WCHAR_TYPE;
    public PrimitiveNode WSTRING_TYPE;
    public PrimitiveNode VALUEBASE_TYPE;

    public RepositoryNode(NodeFactory factory, ErrorReporter ER, TypeMapper mapper, CommonOptions options) {
        super(17);
        this.init(factory, ER, mapper, options);
    }

    void addNode(Node node) {
        if (this._assignObjectKeys && node != null) {
            node._objectKey = new ObjectKey();
            if (this._ER._verbose) {
                System.err.println("Adding node ".concat(String.valueOf(node._objectKey)));
            }
            this._objectTable.put(node._objectKey, node);
        }
    }

    public void assignObjectKeys() {
        this._assignObjectKeys = true;
        this.addNode(this);
        this.addNode(this.ANY_TYPE);
        this.addNode(this.BOOL_TYPE);
        this.addNode(this.CHAR_TYPE);
        this.addNode(this.DOUBLE_TYPE);
        this.addNode(this.FLOAT_TYPE);
        this.addNode(this.LONGDOUBLE_TYPE);
        this.addNode(this.LONGLONG_TYPE);
        this.addNode(this.LONG_TYPE);
        this.addNode(this.OBJREF_TYPE);
        this.addNode(this.OCTET_TYPE);
        this.addNode(this.PRINCIPAL_TYPE);
        this.addNode(this.SHORT_TYPE);
        this.addNode(this.STRING_TYPE);
        this.addNode(this.TYPECODE_TYPE);
        this.addNode(this.ULONGLONG_TYPE);
        this.addNode(this.ULONG_TYPE);
        this.addNode(this.USHORT_TYPE);
        this.addNode(this.VOID_TYPE);
        this.addNode(this.WCHAR_TYPE);
        this.addNode(this.WSTRING_TYPE);
        this.addNode(this.VALUEBASE_TYPE);
    }

    public void clear() {
        this._contents.removeAllElements();
        this._repIdTable.clear();
        this._strings.clear();
        this._wstrings.clear();
        this._arrays.removeAllElements();
        this._sequences.removeAllElements();
        this._fixeds.clear();
        this._objectTable.clear();
        this.assignObjectKeys();
    }

    public Vector contents() {
        return this._contents;
    }

    public Node define(int type, String name, String repId, String version, String comment) {
        return Node.define(type, name, this, repId, version, comment, this._contents);
    }

    public Node define(int type, String name, String repId, String version, String comment, boolean forwardDecl) {
        return Node.define(type, name, this, repId, version, comment, this._contents, forwardDecl);
    }

    public void dump() {
        System.out.println("<REPOSITORY>");
        for (int i = 0; i < this._contents.size(); ++i) {
            RepositoryNode.dump("  ", (ContainedNode)this._contents.elementAt(i));
        }
    }

    private static void dump(String indent, ContainedNode c) {
        System.out.println(String.valueOf(indent).concat(String.valueOf(c._name)));
        if (c.isContainer()) {
            ContainedContainerNode container = (ContainedContainerNode)c;
            for (int i = 0; i < container._contents.size(); ++i) {
                RepositoryNode.dump(String.valueOf(indent).concat("  "), (ContainedNode)container._contents.elementAt(i));
            }
        }
    }

    public Vector find(String name, int depth, int type, boolean excludeInherited) {
        return Node.find(this._contents, name, depth, type, excludeInherited);
    }

    public void finishParameterizedTypes() {
        int i;
        int len = this._arrays.size();
        for (i = 0; i < len; ++i) {
            ((ArrayNode)this._arrays.elementAt(i)).finish(6);
        }
        len = this._sequences.size();
        for (i = 0; i < len; ++i) {
            ((SequenceNode)this._sequences.elementAt(i)).finish(6);
        }
        Enumeration e = this._strings.elements();
        while (e.hasMoreElements()) {
            ((StringNode)e.nextElement()).finish(6);
        }
        e = this._wstrings.elements();
        while (e.hasMoreElements()) {
            ((WStringNode)e.nextElement()).finish(6);
        }
        e = this._fixeds.elements();
        while (e.hasMoreElements()) {
            ((FixedNode)e.nextElement()).finish(6);
        }
    }

    public ArrayNode getArray(Type baseType, int length) {
        int len = this._arrays.size();
        for (int i = 0; i < len; ++i) {
            ArrayNode arrayNode = (ArrayNode)this._arrays.elementAt(i);
            if (arrayNode._type != baseType || arrayNode._length != length) continue;
            arrayNode._fileNumber = this._ER._currentFileNumber;
            arrayNode._lineNumber = this._ER._currentLineNumber;
            return arrayNode;
        }
        return this.makeArray(baseType, length, true);
    }

    public FixedNode getFixed(short digits, short scale) {
        Integer _length;
        FixedNode ret;
        if (digits <= 0 || digits >= 32) {
            this.error("Comp.AST.fixedOutOfRange", new Object[]{new Integer(32)});
        }
        if (scale < 0 || scale > digits) {
            this.error("Comp.AST.fixedScaleOutOfRange", new Object[]{new Integer(digits), new Integer(scale)});
        }
        if ((ret = (FixedNode)this._fixeds.get(_length = new Integer((digits << 16) + scale))) == null) {
            ret = (FixedNode)this._factory.create(19);
            ret._digits = digits;
            ret._scale = scale;
            ret._repository = this;
            this._fixeds.put(_length, ret);
        }
        ret._fileNumber = this._ER._currentFileNumber;
        ret._lineNumber = this._ER._currentLineNumber;
        return ret;
    }

    public PrimitiveNode getPrimitive(int kind) {
        switch (kind) {
            case 11: {
                return this.ANY_TYPE;
            }
            case 8: {
                return this.BOOL_TYPE;
            }
            case 9: {
                return this.CHAR_TYPE;
            }
            case 7: {
                return this.DOUBLE_TYPE;
            }
            case 6: {
                return this.FLOAT_TYPE;
            }
            case 3: {
                return this.LONG_TYPE;
            }
            case 18: {
                return this.LONGDOUBLE_TYPE;
            }
            case 16: {
                return this.LONGLONG_TYPE;
            }
            case 15: {
                return this.OBJREF_TYPE;
            }
            case 10: {
                return this.OCTET_TYPE;
            }
            case 13: {
                return this.PRINCIPAL_TYPE;
            }
            case 2: {
                return this.SHORT_TYPE;
            }
            case 14: {
                return this.STRING_TYPE;
            }
            case 12: {
                return this.TYPECODE_TYPE;
            }
            case 5: {
                return this.ULONG_TYPE;
            }
            case 17: {
                return this.ULONGLONG_TYPE;
            }
            case 4: {
                return this.USHORT_TYPE;
            }
            case 1: {
                return this.VOID_TYPE;
            }
            case 19: {
                return this.WCHAR_TYPE;
            }
            case 20: {
                return this.WSTRING_TYPE;
            }
            case 21: {
                return this.VALUEBASE_TYPE;
            }
        }
        this._ER.error("Comp.AST.invalidType", new Object[]{PrimitiveNode.typeName(kind), new Integer(kind)});
        return null;
    }

    public SequenceNode getSequence(Type baseType, int bound, boolean aliasContext) {
        int len = this._sequences.size();
        for (int i = 0; i < len; ++i) {
            SequenceNode sequenceNode = (SequenceNode)this._sequences.elementAt(i);
            if (sequenceNode._type != baseType || sequenceNode._bound != bound) continue;
            sequenceNode._fileNumber = this._ER._currentFileNumber;
            sequenceNode._lineNumber = this._ER._currentLineNumber;
            return sequenceNode;
        }
        return this.makeSequence(baseType, bound, true);
    }

    public Type getString(int bound) {
        if (bound == 0) {
            return this.STRING_TYPE;
        }
        Integer _length = new Integer(bound);
        StringNode ret = (StringNode)this._strings.get(_length);
        if (ret == null) {
            ret = (StringNode)this._factory.create(14);
            ret._bound = bound;
            ret._repository = this;
            this._strings.put(_length, ret);
        }
        ret._fileNumber = this._ER._currentFileNumber;
        ret._lineNumber = this._ER._currentLineNumber;
        return ret;
    }

    public Type getWString(int bound) {
        if (bound == 0) {
            return this.WSTRING_TYPE;
        }
        Integer _length = new Integer(bound);
        WStringNode ret = (WStringNode)this._wstrings.get(_length);
        if (ret == null) {
            ret = (WStringNode)this._factory.create(18);
            ret._bound = bound;
            ret._repository = this;
            this._wstrings.put(_length, ret);
        }
        ret._fileNumber = this._ER._currentFileNumber;
        ret._lineNumber = this._ER._currentLineNumber;
        return ret;
    }

    private void init(NodeFactory factory, ErrorReporter ER, TypeMapper mapper, CommonOptions options) {
        this._factory = factory;
        this._ER = ER;
        this._mapper = mapper;
        this._options = options;
        this._repository = this;
        this.ANY_TYPE = this._factory.getPrimitive(11);
        this.ANY_TYPE._repository = this;
        this.ANY_TYPE.finish(6);
        this.BOOL_TYPE = this._factory.getPrimitive(8);
        this.BOOL_TYPE._repository = this;
        this.BOOL_TYPE.finish(6);
        this.CHAR_TYPE = this._factory.getPrimitive(9);
        this.CHAR_TYPE._repository = this;
        this.CHAR_TYPE.finish(6);
        this.DOUBLE_TYPE = this._factory.getPrimitive(7);
        this.DOUBLE_TYPE._repository = this;
        this.DOUBLE_TYPE.finish(6);
        this.FLOAT_TYPE = this._factory.getPrimitive(6);
        this.FLOAT_TYPE._repository = this;
        this.FLOAT_TYPE.finish(6);
        this.LONGDOUBLE_TYPE = this._factory.getPrimitive(18);
        this.LONGDOUBLE_TYPE._repository = this;
        this.LONGDOUBLE_TYPE.finish(6);
        this.LONGLONG_TYPE = this._factory.getPrimitive(16);
        this.LONGLONG_TYPE._repository = this;
        this.LONGLONG_TYPE.finish(6);
        this.LONG_TYPE = this._factory.getPrimitive(3);
        this.LONG_TYPE._repository = this;
        this.LONG_TYPE.finish(6);
        this.OBJREF_TYPE = this._factory.getPrimitive(15);
        this.OBJREF_TYPE._repository = this;
        this.OBJREF_TYPE.finish(6);
        this.OCTET_TYPE = this._factory.getPrimitive(10);
        this.OCTET_TYPE._repository = this;
        this.OCTET_TYPE.finish(6);
        this.PRINCIPAL_TYPE = this._factory.getPrimitive(13);
        this.PRINCIPAL_TYPE._repository = this;
        this.PRINCIPAL_TYPE.finish(6);
        this.SHORT_TYPE = this._factory.getPrimitive(2);
        this.SHORT_TYPE._repository = this;
        this.SHORT_TYPE.finish(6);
        this.STRING_TYPE = this._factory.getPrimitive(14);
        this.STRING_TYPE._repository = this;
        this.STRING_TYPE.finish(6);
        this.TYPECODE_TYPE = this._factory.getPrimitive(12);
        this.TYPECODE_TYPE._repository = this;
        this.TYPECODE_TYPE.finish(6);
        this.ULONGLONG_TYPE = this._factory.getPrimitive(17);
        this.ULONGLONG_TYPE._repository = this;
        this.ULONGLONG_TYPE.finish(6);
        this.ULONG_TYPE = this._factory.getPrimitive(5);
        this.ULONG_TYPE._repository = this;
        this.ULONG_TYPE.finish(6);
        this.USHORT_TYPE = this._factory.getPrimitive(4);
        this.USHORT_TYPE._repository = this;
        this.USHORT_TYPE.finish(6);
        this.VOID_TYPE = this._factory.getPrimitive(1);
        this.VOID_TYPE._repository = this;
        this.VOID_TYPE.finish(6);
        this.WCHAR_TYPE = this._factory.getPrimitive(19);
        this.WCHAR_TYPE._repository = this;
        this.WCHAR_TYPE.finish(6);
        this.WSTRING_TYPE = this._factory.getPrimitive(20);
        this.WSTRING_TYPE._repository = this;
        this.WSTRING_TYPE.finish(6);
    }

    public ContainedNode lookup(QName qname, boolean local) {
        if (qname._s.startsWith("::")) {
            qname._s = qname._s.substring(2);
        }
        for (int i = 0; i < this._contents.size(); ++i) {
            ContainedNode elem = (ContainedNode)this._contents.elementAt(i);
            if (!elem._name.equalsIgnoreCase(qname._s)) continue;
            if (!elem._name.equals(qname._s)) {
                elem.warnCaseViolation(qname._s);
            }
            if (qname._next == null) {
                return elem;
            }
            if (!elem.isContainer()) continue;
            return ((ContainedContainerNode)elem).lookup(qname._next, true);
        }
        return null;
    }

    public ContainedNode lookup(String name, boolean local) {
        for (int i = 0; i < this._contents.size(); ++i) {
            ContainedNode elem = (ContainedNode)this._contents.elementAt(i);
            if (!elem._name.equalsIgnoreCase(name)) continue;
            return elem;
        }
        return null;
    }

    public ContainedNode lookupId(String repId) {
        return (ContainedNode)this._repIdTable.get(repId);
    }

    protected ArrayNode makeArray(Type baseType, int length, boolean recordInTable) {
        ArrayNode ret = (ArrayNode)this._factory.create(16);
        ret._type = baseType;
        ret._length = length;
        ret._repository = this;
        ret._fileNumber = this._ER._currentFileNumber;
        ret._lineNumber = this._ER._currentLineNumber;
        if (recordInTable) {
            this._arrays.addElement(ret);
        }
        return ret;
    }

    protected SequenceNode makeSequence(Type baseType, int bound, boolean recordInTable) {
        SequenceNode ret = (SequenceNode)this._factory.create(15);
        ret._type = baseType;
        ret._bound = bound;
        ret._repository = this;
        ret._fileNumber = this._ER._currentFileNumber;
        ret._lineNumber = this._ER._currentLineNumber;
        if (recordInTable) {
            this._sequences.addElement(ret);
        }
        return ret;
    }

    public void merge(RepositoryNode rep, boolean allowMerge) {
        RepositoryNode.mergeContent(this, this._contents, rep._contents, allowMerge);
        this.recomputeCachedInfo();
    }

    private static Vector mergeContent(ContainerNode container, Vector v1, Vector v2, boolean allowMerge) {
        int len1 = v1.size();
        block0: for (int i = 0; i < len1; ++i) {
            ContainedNode a = (ContainedNode)v1.elementAt(i);
            int len2 = v2.size();
            for (int j = 0; j < len2; ++j) {
                ContainedNode b = (ContainedNode)v2.elementAt(j);
                if (!a._name.equals(b._name)) continue;
                if (a._kind == 6 || a.isContainer() && allowMerge) {
                    ContainedContainerNode tmp1 = (ContainedContainerNode)a;
                    ContainedContainerNode tmp2 = (ContainedContainerNode)b;
                    tmp2._contents = RepositoryNode.mergeContent(tmp2, tmp1._contents, tmp2._contents, allowMerge);
                }
                v1.setElementAt(b, i);
                b._container = container;
                continue block0;
            }
        }
        int len2 = v2.size();
        block2: for (int j = 0; j < len2; ++j) {
            int len12 = v1.size();
            for (int i = 0; i < len12; ++i) {
                if (v2.elementAt(j).equals(v1.elementAt(i))) continue block2;
            }
            ContainedNode c = (ContainedNode)v2.elementAt(j);
            v1.addElement(c);
            c._container = container;
        }
        return v2;
    }

    public final int numObjects() {
        return 1 + this._repIdTable.size() + this._strings.size() + this._wstrings.size() + this._arrays.size() + this._sequences.size() + this._fixeds.size();
    }

    public void recomputeCachedInfo() {
        Hashtable oldRepIdTable = this._repIdTable;
        this._repIdTable = new Hashtable();
        this.recomputeRepIdTable(this);
        this.recomputeCachedInfo(this);
        Enumeration e = oldRepIdTable.elements();
        while (e.hasMoreElements()) {
            ContainedNode cn = (ContainedNode)e.nextElement();
            Node n = (Node)this._repIdTable.get(cn._repId);
            if (n == null) continue;
            n._objectKey = cn._objectKey;
        }
        e = this._repIdTable.elements();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            this._objectTable.put(n._objectKey, n);
        }
    }

    private void recomputeCachedInfo(Node node) {
        int len;
        node._repository = this;
        if (node._kind == 9) {
            AliasNode alias = (AliasNode)node;
            alias._type = this.recomputeCachedInfo(alias._type);
        } else if (node._kind == 21) {
            ValueBoxNode vbox = (ValueBoxNode)node;
            vbox._type = this.recomputeCachedInfo(vbox._type);
        } else if (node.isInheritable()) {
            InheritableNode inh = (InheritableNode)node;
            this.recomputeCachedInfo(inh._bases);
            if (inh._kind == 20) {
                ValueNode value = (ValueNode)inh;
                int len2 = value._bases.size();
                int absBase = 0;
                int absInterface = 0;
                block4: for (int i = 0; i < len2; ++i) {
                    InheritableNode n = (InheritableNode)value._bases.elementAt(i);
                    switch (n._kind) {
                        case 20: {
                            if (n._abstract) {
                                value._abstractBases.setElementAt(n, absBase++);
                                continue block4;
                            }
                            value._concreteBase = (ValueNode)n;
                            continue block4;
                        }
                        case 5: {
                            if (n._abstract) {
                                value._abstractInterfaces.setElementAt(n, absInterface++);
                                continue block4;
                            }
                            value._supportedInterface = (InterfaceNode)n;
                        }
                    }
                }
            }
            ((InheritableNode)node).cache();
        } else if (node._kind == 3) {
            ConstantNode constant = (ConstantNode)node;
            constant._type = this.recomputeCachedInfo(constant._type);
        } else if (node._kind == 22) {
            ValueMemberNode vmember = (ValueMemberNode)node;
            vmember._type = this.recomputeCachedInfo(vmember._type);
        } else if (node.hasFields()) {
            this.recomputeCachedInfo(((FieldNode)node)._memberTypes);
            if (node._kind == 11) {
                UnionNode union = (UnionNode)node;
                union._discriminator = this.recomputeCachedInfo(union._discriminator);
            }
        } else if (node._kind == 7) {
            OperationNode op = (OperationNode)node;
            this.recomputeCachedInfo(op._paramTypes);
            op._result = this.recomputeCachedInfo(op._result);
            len = op._exceptions.size();
            for (int i = 0; i < len; ++i) {
                op._exceptions.setElementAt((ExceptionNode)this._repIdTable.get(((ExceptionNode)op._exceptions.elementAt((int)i))._repId), i);
            }
        } else if (node._kind == 2) {
            AttributeNode attr = (AttributeNode)node;
            attr._type = this.recomputeCachedInfo(attr._type);
        }
        if (node.isContainer()) {
            Vector v = ((ContainerNode)((Object)node)).contents();
            len = v.size();
            for (int i = 0; i < len; ++i) {
                this.recomputeCachedInfo((Node)v.elementAt(i));
            }
        }
    }

    private Type recomputeCachedInfo(PrimitiveNode primitive) {
        switch (primitive._pkind) {
            case 11: {
                return this.ANY_TYPE;
            }
            case 8: {
                return this.BOOL_TYPE;
            }
            case 9: {
                return this.CHAR_TYPE;
            }
            case 7: {
                return this.DOUBLE_TYPE;
            }
            case 6: {
                return this.FLOAT_TYPE;
            }
            case 18: {
                return this.LONGDOUBLE_TYPE;
            }
            case 16: {
                return this.LONGLONG_TYPE;
            }
            case 3: {
                return this.LONG_TYPE;
            }
            case 15: {
                return this.OBJREF_TYPE;
            }
            case 10: {
                return this.OCTET_TYPE;
            }
            case 13: {
                return this.PRINCIPAL_TYPE;
            }
            case 2: {
                return this.SHORT_TYPE;
            }
            case 14: {
                return this.STRING_TYPE;
            }
            case 12: {
                return this.TYPECODE_TYPE;
            }
            case 17: {
                return this.ULONGLONG_TYPE;
            }
            case 5: {
                return this.ULONG_TYPE;
            }
            case 4: {
                return this.USHORT_TYPE;
            }
            case 1: {
                return this.VOID_TYPE;
            }
            case 19: {
                return this.WCHAR_TYPE;
            }
            case 20: {
                return this.WSTRING_TYPE;
            }
            case 21: {
                return this.VALUEBASE_TYPE;
            }
        }
        this._ER.internalError("RepositoryNode.recomputeCachedInfo(PrimitiveNode): unexpected primitive type ".concat(String.valueOf(primitive.typeName())));
        return null;
    }

    private Type recomputeCachedInfo(Type type) {
        switch (type.kind()) {
            case 16: {
                ArrayNode array = (ArrayNode)type;
                array._type = this.recomputeCachedInfo(array._type);
                return this.getArray(array._type, array._length);
            }
            case 15: {
                SequenceNode sequence = (SequenceNode)type;
                sequence._type = this.recomputeCachedInfo(sequence._type);
                return this.getSequence(sequence._type, sequence._bound, false);
            }
            case 14: {
                return this.getString(((StringNode)type)._bound);
            }
            case 18: {
                return this.getWString(((WStringNode)type)._bound);
            }
            case 19: {
                return this.getFixed(((FixedNode)type)._digits, ((FixedNode)type)._scale);
            }
            case 13: {
                return this.recomputeCachedInfo((PrimitiveNode)type);
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 23: {
                return (Type)this._repIdTable.get(((ContainedNode)((Object)type))._repId);
            }
        }
        this._repository._ER.internalError("RepositoryNode.recomputeCachedInfo(Type): unexpected type ".concat(String.valueOf(((Node)((Object)type)).typeName())));
        return null;
    }

    private void recomputeCachedInfo(Vector v) {
        int len = v.size();
        for (int i = 0; i < len; ++i) {
            v.setElementAt(this.recomputeCachedInfo((Type)v.elementAt(i)), i);
        }
    }

    private void recomputeRepIdTable(ContainerNode container) {
        Vector v = container.contents();
        int len = v.size();
        for (int i = 0; i < len; ++i) {
            ContainedNode n = (ContainedNode)v.elementAt(i);
            this.updateId(n);
            if (!n.isContainer()) continue;
            this.recomputeRepIdTable((ContainerNode)((Object)n));
        }
    }

    public void replaceId(String repId, ContainedNode node) {
        Object o = this._repIdTable.get(repId);
        if (o != null && o != node) {
            this.error("Comp.AST.repIdAlreadyExists");
            return;
        }
        this._repIdTable.remove(repId);
        this.updateId(node);
    }

    public void updateId(ContainedNode node) {
        if (node._repId != null) {
            this._repIdTable.put(node._repId, node);
        }
    }

    public void updateOptionsDependencies() {
        this._mapper.updateOptionsDependencies();
    }
}

